/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\u00020\u00148\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "", "millis", "Ljava/time/LocalTime;", "kotlin.jvm.PlatformType", "longToLocalTime", "(J)Ljava/time/LocalTime;", "", "value", "", "nonNullValueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "notNullValueToDB", "(Ljava/lang/Object;)Ljava/lang/Object;", "sqlType", "()Ljava/lang/String;", "valueFromDB", "(Ljava/lang/Object;)Ljava/time/LocalTime;", "", "hasTimePart", "Z", "getHasTimePart", "()Z", "<init>", "()V", "Companion", "exposed-java-time"})
public final class JavaLocalTimeColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaLocalTimeColumnType INSTANCE = new JavaLocalTimeColumnType();

    public JavaLocalTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().timeType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object2 = value2;
        if (object2 instanceof String) {
            return (String)value2;
        }
        if (object2 instanceof LocalTime) {
            object = value2;
        } else if (object2 instanceof Time) {
            object = Instant.ofEpochMilli(((Time)value2).getTime()).atZone(ZoneId.systemDefault());
        } else if (object2 instanceof Timestamp) {
            object = Instant.ofEpochMilli(((Timestamp)value2).getTime()).atZone(ZoneId.systemDefault());
        } else {
            throw new IllegalStateException(("Unexpected value: " + value2 + " of " + Reflection.getOrCreateKotlinClass(value2.getClass()).getQualifiedName()).toString());
        }
        Object instant = object;
        DateTimeFormatter formatter = DefaultKt.getCurrentDialect() instanceof OracleDialect ? JavaDateColumnTypeKt.getORACLE_TIME_STRING_FORMATTER() : JavaDateColumnTypeKt.getDEFAULT_TIME_STRING_FORMATTER();
        return '\'' + formatter.format((TemporalAccessor)instant) + '\'';
    }

    @Override
    @NotNull
    public LocalTime valueFromDB(@NotNull Object value2) {
        LocalTime localTime;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof LocalTime) {
            localTime = (LocalTime)value2;
        } else if (object instanceof Time) {
            LocalTime localTime2 = ((Time)value2).toLocalTime();
            Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"value.toLocalTime()");
            localTime = localTime2;
        } else if (object instanceof Timestamp) {
            LocalTime localTime3 = ((Timestamp)value2).toLocalDateTime().toLocalTime();
            Intrinsics.checkNotNullExpressionValue((Object)localTime3, (String)"value.toLocalDateTime().toLocalTime()");
            localTime = localTime3;
        } else if (object instanceof Integer) {
            LocalTime localTime4 = this.longToLocalTime(((Number)value2).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)localTime4, (String)"longToLocalTime(value.toLong())");
            localTime = localTime4;
        } else if (object instanceof Long) {
            LocalTime localTime5 = this.longToLocalTime(((Number)value2).longValue());
            Intrinsics.checkNotNullExpressionValue((Object)localTime5, (String)"longToLocalTime(value)");
            localTime = localTime5;
        } else if (object instanceof String) {
            DateTimeFormatter formatter = DefaultKt.getCurrentDialect() instanceof OracleDialect ? JavaDateColumnTypeKt.formatterForDateString((String)value2) : JavaDateColumnTypeKt.getDEFAULT_TIME_STRING_FORMATTER();
            LocalTime localTime6 = LocalTime.parse((CharSequence)value2, formatter);
            Intrinsics.checkNotNullExpressionValue((Object)localTime6, (String)"{\n            val format\u2026lue, formatter)\n        }");
            localTime = localTime6;
        } else {
            localTime = this.valueFromDB(value2.toString());
        }
        return localTime;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (value2 instanceof LocalTime) {
            Time time = Time.valueOf((LocalTime)value2);
            Intrinsics.checkNotNullExpressionValue((Object)time, (String)"valueOf(value)");
            object = time;
        } else {
            object = value2;
        }
        return object;
    }

    private final LocalTime longToLocalTime(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalTime();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType$Companion;", "", "Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "<init>", "()V", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaLocalTimeColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

